
/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#include "WLTouch.hpp"
#include "WLSurfaceEvent.hpp"

using namespace WaylandBackend;

const struct wl_touch_listener WLTouch::_touchListener =
{
        WLTouch::touchHandleDown,
        WLTouch::touchHandleUp,
        WLTouch::touchHandleMotion,
        WLTouch::touchHandleFrame,
        WLTouch::touchHandleCancel,
};

WLTouch::WLTouch(struct wl_seat *wlSeat, struct wl_event_queue *eventQ)
:_wlTouch(NULL)
,_wlSeat(wlSeat)
,_touchFocus(NULL)
{
    if (NULL != eventQ)
    {
        struct wl_seat* wrappedSeat = (struct wl_seat*)
                                wl_proxy_create_wrapper((void *)wlSeat);
        if (NULL != wrappedSeat)
        {
            wl_proxy_set_queue((struct wl_proxy*)wrappedSeat, eventQ);
            _wlTouch = (struct wl_touch*) wl_seat_get_touch(wrappedSeat);
            wl_proxy_wrapper_destroy(wrappedSeat);
        }
    }
    else
    {
        /*
         * It is not good idea to use default queue. default queue can be
         * dispatched by multiple threads
         */
        _wlTouch = (struct wl_touch*) wl_seat_get_touch(wlSeat);
    }
    if (NULL != _wlTouch)
        wl_touch_add_listener(_wlTouch, &_touchListener, (void*)this);

}

void
WLTouch::clearIfFocusMatches(struct wl_surface *wlSurface)
{
    if (_touchFocus == wlSurface)
        _touchFocus = NULL;
}

void
WLTouch::touchHandleDown(void* data, struct wl_touch* touch,
                         uint32_t serial, uint32_t time,
                         struct wl_surface* surface, int32_t id,
                         wl_fixed_t xw, wl_fixed_t yw)
{
    WLTouch *pwlTouch = static_cast<WLTouch*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != surface)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                         (wl_surface_get_user_data(surface));
        if (NULL != pInputlistener)
            pInputlistener->touchDown((void*)pwlTouch->_wlSeat, serial, time,
                                      id, wl_fixed_to_double(xw),
                                      wl_fixed_to_double(yw));
    }
    pwlTouch->_touchFocus = surface;
}

void
WLTouch::touchHandleMotion(void* data, struct wl_touch* touch,
                           uint32_t time, int32_t id, wl_fixed_t xw,
                           wl_fixed_t yw)
{
    WLTouch *pwlTouch = static_cast<WLTouch*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != pwlTouch->_touchFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                       (wl_surface_get_user_data(pwlTouch->_touchFocus));
        if (NULL != pInputlistener)
            pInputlistener->touchMotion((void*)pwlTouch->_wlSeat, time, id,
                                        wl_fixed_to_double(xw),
                                        wl_fixed_to_double(yw));
    }
}

void
WLTouch::touchHandleFrame(void* data, struct wl_touch* touch)
{
    WLTouch *pwlTouch = static_cast<WLTouch*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != pwlTouch->_touchFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                         (wl_surface_get_user_data(pwlTouch->_touchFocus));
        if (NULL != pInputlistener)
            pInputlistener->touchFrame((void*)pwlTouch->_wlSeat);
    }
}

void
WLTouch::touchHandleCancel(void* data, struct wl_touch* touch)
{
    WLTouch *pwlTouch = static_cast<WLTouch*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != pwlTouch->_touchFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                         (wl_surface_get_user_data(pwlTouch->_touchFocus));
        if (NULL != pInputlistener)
            pInputlistener->touchCancel((void*)pwlTouch->_wlSeat);
    }
}

void
WLTouch::touchHandleUp(void* data, struct wl_touch* touch,
                            uint32_t serial, uint32_t time, int32_t id)
{
    WLTouch *pwlTouch = static_cast<WLTouch*>(data);
    WLSurfaceEvent *pInputlistener;
    if(NULL != pwlTouch->_touchFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                         (wl_surface_get_user_data(pwlTouch->_touchFocus));
        if (NULL != pInputlistener)
            pInputlistener->touchUp((void*)pwlTouch->_wlSeat, serial, time, id);
    }
}

WLTouch::~WLTouch()
{
    if (NULL != _wlTouch)
    {
        wl_touch_destroy(_wlTouch);
    }
}
